//***************************************************************************************
// Header File Included Area
//***************************************************************************************
#include "SYSTEM.H"
#include "SACM.H"
#include "ComAir5_RX.H"
#include "ComAir5_IOTX.H"

//***************************************************************************************
// Constant Definitioin Area
//***************************************************************************************
#define D_IOB3			0x0008

//***************************************************************************************
// Function pre-announcement Area
//***************************************************************************************
void main_CH();
void main_EN();
void PlayTX(int, int);
void PlayRX(int, int);
void Display(int);

void USER_A1800_SetStartAddr(int);
void USER_A1800_SetStartAddr_Con(int);
//***************************************************************************************
// RAM Definition Area
//***************************************************************************************
short *P_IOB_Buffer = 0x2005;
short *P_IOB_Data = 0x2004;

int temp;
int i, j;

//***************************************************************************************
// Table Definition Area
//***************************************************************************************

//***************************************************************************************
// CODE Definition Area
//***************************************************************************************

//***************************************************************************************
// Function: 		int main(void)
// Description:		main program
// Parameter:		None
// Return:			None
// Note:			IOB3 = 0, Command Mix Speech
//					IOB3 != 0, Command After Speech
//***************************************************************************************
int main()
{
	System_Initial();								// System initial
	SPI_Initial();
	ComAir5_IOTX_Init(17000, 200);					// IO toggle
	Display(0x00FF);
	while(1)
	{
		if((*P_IOB_Data & D_IOB3) == 0)
			main_CH();
		else
			main_EN();
	}
	return 0;
}

//***************************************************************************************
// Function: 		void main_CH(void)
// Description:		Send command mix speech playing at TX mode
// Parameter:		None
// Return:			None
// Note:			IOB3 = 0, Command Mix Speech
//					IOB3 != 0, Command After Speech
//***************************************************************************************
void main_CH()
{
	int R_Key;
	short Command = 0;
	int R_SpeechIndex = 0;
	
	ComAir5_RX_Init(17000, 200);
	ComAir5_RX_Start(10);
	while(1)
	{
		if((*P_IOB_Data & D_IOB3) != 0)	break;			
		R_Key = SP_GetCh();
		switch(R_Key)
		{
			
			case 0x0002:
				if(++R_SpeechIndex > 79) R_SpeechIndex = 0;
				PlayTX(R_SpeechIndex,0);
				break;
			case 0x0004:
				if(--R_SpeechIndex < 0) R_SpeechIndex = 79;
				PlayTX(R_SpeechIndex,0);
				break;
			default:
				break;
		}
		
		Command = ComAir5_RX_GetCommand();
		if(Command != -1 && Command <= 79)
		{
			ComAir5_RX_Stop();			
			Display(Command);
			PlayRX(Command, 0);
			ComAir5_RX_Init(17000, 200);
			ComAir5_RX_Start(10);
			Display(0x00FF);
		}
		ComAir5_RX_ServiceLoop();			
		System_ServiceLoop();			
	}	
}

//***************************************************************************************
// Function: 		void main_EN(void)
// Description:		Send command mix speech playing at TX mode
// Parameter:		None
// Return:			None
// Note:			IOB3 = 0, Command Mix Speech
//					IOB3 != 0, Command After Speech
//***************************************************************************************
void main_EN()
{
	int R_Key;
	short Command = 0;
	int R_SpeechIndex = 0;
	
	ComAir5_RX_Init(17000, 200);
	ComAir5_RX_Start(10);
	while(1)
	{
		if((*P_IOB_Data & D_IOB3) == 0)	break;			
		R_Key = SP_GetCh();
		switch(R_Key)
		{
			
			case 0x0002:
				if(++R_SpeechIndex > 79) R_SpeechIndex = 0;
				PlayTX(R_SpeechIndex, 1);
				break;
			case 0x0004:
				if(--R_SpeechIndex < 0) R_SpeechIndex = 79;
				PlayTX(R_SpeechIndex, 1);
				break;
			default:
				break;
		}
		
		Command = ComAir5_RX_GetCommand();
		if(Command != -1 && Command <= 79)
		{
			ComAir5_RX_Stop();			
			Display(Command);
			PlayRX(Command, 1);
			ComAir5_RX_Init(17000, 200);
			ComAir5_RX_Start(10);
			Display(0x00FF);
		}
		ComAir5_RX_ServiceLoop();			
		System_ServiceLoop();			
	}	
}


//***************************************************************************************
// Function: 		void PlayRX(int speechIndex)
// Description:		Play received index speech
// Parameter:		speechIndex
// Return:			None
//***************************************************************************************
void PlayRX(int speechIdx, int language)
{
	SACM_A1800_Initial();							// fiq on
	USER_A1800_Volume(9);
	if(language == 1)
		USER_A1800_SetStartAddr(speechIdx+80);
	else
		USER_A1800_SetStartAddr(speechIdx);
		
	SACM_A1800_Play(Manual_Mode_Index, DAC1, Ramp_Up+Ramp_Dn);
	while(SACM_A1800_Status() != 0)
	{
		SACM_A1800_ServiceLoop();
		System_ServiceLoop();			
	}
	SACM_A1800_Stop();
}		


//***************************************************************************************
// Function: 		void PlayRX(int speechIndex)
// Description:		Play received index speech
// Parameter:		speechIndex
// Return:			None
//***************************************************************************************
void PlayTX(int speechIdx, int Language)
{
	int test;
	SACM_A1800_Initial();							// fiq on
	USER_A1800_Volume(9);
	if(Language == 1)
		USER_A1800_SetStartAddr(speechIdx+80);
	else
		USER_A1800_SetStartAddr(speechIdx);
		
	SACM_A1800_Play(Manual_Mode_Index, DAC1, Ramp_Up+Ramp_Dn);
	ComAir5_IOTX_Send(speechIdx);
	Display(speechIdx);
	while( SACM_A1800_Status()!=0 || ComAir5_IOTX_Status()!=0)
	{
		SP_GetCh();
		SACM_A1800_ServiceLoop();
		System_ServiceLoop();			
	}
	test = ComAir5_IOTX_Status();
	SACM_A1800_Stop();
	Display(0x00FF);
	ComAir5_RX_Init(17000, 200);
	ComAir5_RX_Start(10);
}		
//***************************************************************************************
// Function: void Display(int)
//***************************************************************************************
void Display(int command)
{
	temp = *P_IOB_Buffer;
	temp &= 0x00FF;
	temp |= command << 8;
	*P_IOB_Buffer = temp;
}

//***************************************************************************************
// Function: int BitMap(int)
//***************************************************************************************
int BitMap(int Key)
{
	int ret;
	switch(Key)
	{
		case 0x0001:
			ret = 0;
			break;
		case 0x0002:
			ret = 0;
			break;
		case 0x0004:
			ret = 1;
			break;
		case 0x0008:
			ret = 2;
			break;
		case 0x0010:
			ret = 3;
			break;
		case 0x0020:
			ret = 4;
			break;
		case 0x0040:
			ret = 5;
			break;
		case 0x0080:
			ret = 6;
			break;
	}	
	return	ret;
}